package ch.frankel.blog.lombok.handler;

import java.util.HashMap;
import java.util.Map;

import com.sun.tools.javac.code.TypeTags;

/**
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
public class ReturnTypeMapper implements Mapper<Class<?>, Integer> {

    /** Map. */
    private static final Map<Class<?>, Integer> RETURN_TYPE_MAP;

    static {

        RETURN_TYPE_MAP = new HashMap<Class<?>, Integer>(15);

        RETURN_TYPE_MAP.put(void.class, TypeTags.VOID);
        RETURN_TYPE_MAP.put(int.class, TypeTags.INT);
        RETURN_TYPE_MAP.put(long.class, TypeTags.LONG);
        RETURN_TYPE_MAP.put(byte.class, TypeTags.BYTE);
        RETURN_TYPE_MAP.put(boolean.class, TypeTags.BOOLEAN);
        RETURN_TYPE_MAP.put(float.class, TypeTags.FLOAT);
        RETURN_TYPE_MAP.put(double.class, TypeTags.DOUBLE);
        RETURN_TYPE_MAP.put(char.class, TypeTags.CHAR);
        RETURN_TYPE_MAP.put(short.class, TypeTags.SHORT);
    }

    /**
     * @see ch.frankel.blog.lombok.handler.Mapper#get(java.lang.Object)
     */
    @Override
    public Integer get(Class<?> c) {

        return RETURN_TYPE_MAP.get(c);
    }
}
